library CustoFormDll;


uses
  SysUtils,
  Classes,
  Forms,
  Windows,
  controls,
  customform in 'customform.pas' {frmCust},
  SelectForm in 'SelectForm.pas' {frmSelectForm},
  pngzlib in '..\..\..\..\components\png\pngzlib.pas',
  pngimage in '..\..\..\..\components\png\pngimage.pas',
  pnglang in '..\..\..\..\components\png\pnglang.pas';

//Button images are in resource file buttons.res
//Transparent color MUST be RGB(255,0,255) and size 32x32 pix
//The resource file MUST have two bitmap resources; HOTIMAGE and BWIMAGE
//Here is a sample of a custform.rc file
//HOTIMAGE Bitmap cust.bmp
//BWIMAGE Bitmap custbw.bmp
//You can compile the rc file to RES file with BRCC32.EXE

{$R *.RES}
{$R buttons.res}

var
   DllApp : TApplication;
   DllScreen : TScreen;

procedure NewDLLProc(reason : Integer);
begin
   case reason of
      DLL_PROCESS_DETACH : begin
                              if Assigned(DllApp) then
                              begin
                                 //Restore Application and Screen instances before close
                                 Application := DLLApp;
                                 Screen := DLLScreen;
                              end;
                           end;
   end;
end;

procedure ShowPlugin(MainApp : TApplication; MainScreen : TScreen; index : Integer); stdcall;
var sIniFile : String;
    frmSelect : TfrmSelectForm;
begin
   if not Assigned(DllApp) then
   begin
      //The DLL and Mainform has their own Application and Screen instances
      //Save DLL's instances and then use Mainform's instances also in this DLL
      DllApp := Application;
      DllScreen := Screen;
      Application := MainApp;
      Screen := MainScreen;
   end;

   if index = 0 then          // Select new form
   begin
      frmSelect := TfrmSelectForm.Create(Application);
      frmSelect.ShowModal;
      if frmSelect.ModalResult = mrOK then
         sIniFile := frmSelect.cbForm.Items.Strings[frmSelect.cbForm.ItemIndex]
      else
         Exit;
   end;

   with TfrmCust.Create(Application.MainForm) do
   begin
      //if Tag = 0 then this form will receive messages from every sensor
      //if Tag > 0 then this from will receive only messages concerning
      //a sensor that has the same tag (see HKLM\Software\TSa\Temp\Sensors)
      Tag := 0;

      if (index = 0) and (sIniFile <> '') then //This is new childwindow
         InitializeForm(sIniFile+'.cuf')
      else
         if index > 0 then                    // Previous window
            GetPosInfo(index);
   end;
end;

exports
   ShowPlugin;     //This is the procedure that every plugin must export


begin
   DLLProc := @NewDLLProc;
end.
